/*
 * @(#)Simulation.java  2.0  2004-02-02
 *
 * Copyright (c) 2003 Lucerne University of Applied Sciences and Arts (HSLU)
 * Zentralstrasse 18, Postfach 2858, CH-6002 Lucerne, Switzerland
 * All rights reserved.
 *
 * The copyright of this software is owned by the Lucerne University of Applied 
 * Sciences and Arts (HSLU). You may not use, copy or modify this software, 
 * except in accordance with the license agreement you entered into with HSLU. 
 * For details see accompanying license terms. 
 */


package ch.hslu.cm.simulation;

import org.jhotdraw.xml.DOMStorable;

import javax.swing.event.*;
import javax.swing.undo.*;
import java.util.*;
/**
 * A simulation is a collection of elements.
 *
 * @author  Werner Randelshofer
 * @version 2.0 2004-02-02 Revised. 
 * <br>1.0  2. Dezember 2003  Created.
 */
public interface Simulation extends DOMStorable {
    /**
     * Adds an element to the simulation.
     * The simulation sends an <code>addNotify</code> message to the element
     * after it has been added.
     *
     * @param element to be added to the simulation.
     */
    public void add(SimulatedObject element);
    
    /**
     * Removes an element from the simulation.
     * The simulation sends a <code>removeNotify</code>  message to the figure
     * before it is removed.
     * The simulation silently removes the name of the element.
     *
     * @param element to be removed from the simulation.
     */
    public void remove(SimulatedObject element);
    
    /**
     * Returns the number of elements in the simulation.
     * @return the element count.
     */
    public int getElementCount();
    
    /**

     * Returns the elements of the simulation.

     * 

     * @return An immutable Collection of SimulatedObject's.

     */
    public Collection getElements();
    
    
    
    /**
     * Adds a listener for this simulation.
     */
    public void addSimulationListener(SimulationListener listener);
    /**
     * Removes a listener from this drawing.
     */
    public void removeSimulationListener(SimulationListener listener);
    /**
     * Adds a listener for undooable edit events.
     */
    public void addUndoableEditListener(UndoableEditListener l);
    
    /**
     * Removes a listener for undoable edit events.
     */
    public void removeUndoableEditListener(UndoableEditListener l);
    /**
     * Notify all listenerList that have registered interest for
     * notification on this event type.
     * This is used by the elements of the simulation to forward
     * UndoableEdit's to UndoableEditListener's of the Simulation.
     */
    public void fireUndoableEditHappened(UndoableEdit edit);

    /**
     * Invokes the run method of the provided Runnable object on
     * the behaviour thread of this simulation.
     */
    public void invokeBehaviour(final Runnable runner);
    
    /**
     * Delay in milliseconds used to delay real time processes.
     */
    public long getDelay();
}
